viewer.mode=OVERLAY

function setup()
    print("reorder tabs to see different versions")
    tab1={3,9,27,81}
    parameter.action("next",nxt)    
    colr={color(255,0,0),color(0,255,0),
    color(0,255,255),color(255,255,0)}
    assert(OrbitViewer, "Please include Cameras as a dependency")
    scene = craft.scene() 
    v=scene.camera:add(OrbitViewer,vec3(50,50,50), 8, 0, 1000)
    v.rx=30
    v.ry=30
    count=-1
    entity = scene:entity()
    volume = entity:add(craft.volume, 300, 300, 300)
    ss=3
    val=1
    randomColor = color(math.random(255),math.random(255),math.random(255))
    cube(0,0,0,3)  
    setLighting()
end

function setLighting()
    scene.sun.rotation = quat.eulerAngles(45,0,45)   
    scene.ambientColor = color(47)   
    skyMaterial = scene.sky.material
    skyMaterial.horizon = color(180, 214, 212)    
    cameraComponent = scene.camera:get(craft.camera)
    cameraComponent.hdr = true
    cameraComponent.colorTextureEnabled = true
    sunLight = scene.sun:get(craft.light)
    sunLight.intenstity =  80
end

function update(dt)
    scene:update(dt)
end

function draw()
    update(DeltaTime)
    scene:draw()  
end

function nxt()   
    clr=true
    cube(0,0,0,ss)
    val=val+1
    if val>4 then
        val=1
        v.zoom=3
    end
    ss=tab1[val]
    clr=false
    randomColor = color(math.random(255),math.random(255),math.random(255))
    cube(0,0,0,ss)
    v.zoom=v.zoom*2.8
end

function cube(x,y,z,size)
    local s=size//3
    for x1=-s,s,s do
        for y1=-s,s,s do
            for z1=-s,s,s do
                if (y1~=0 or z1~=0) and (x1~=0 or z1~=0) and (x1~=0 or y1~=0) then
                    if size~=3 then
                        cube(x1+x,y1+y,z1+z,s)
                    else
                        if clr then
                            volume:set((x1+x+50), (y1+y+50), (z1+z+50), 'name', 'empty')
                        else
                            volume:set((x1+x+50), (y1+y+50), (z1+z+50), 'name', 'solid', 'color', randomColor)
                        end
                    end
                end
            end            
        end
    end
end   